<?php $this->load->view('admin/head'); ?>
<?php $this->load->view('admin/header'); ?>

<div class="container-fluid py-4">
  <div class="row">
    <div class="col-sm-4 mt-4">
      <div class="card">
        <div class="card-body p-3 position-relative">
          <div class="row">
            <div class="col-7 text-start">
              <p class="text-sm mb-1 text-capitalize font-weight-bold">Total Projects</p>
              <h5 class="font-weight-bolder mb-0">
                 <?php echo($totalprojects); ?>
              </h5>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-4 mt-4">
      <div class="card">
        <div class="card-body p-3 position-relative">
          <div class="row">
            <div class="col-7 text-start">
              <p class="text-sm mb-1 text-capitalize font-weight-bold">Ongoing Projects</p>
              <h5 class="font-weight-bolder mb-0">
              <?php echo($ongoingprojects); ?>
              </h5>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-4 mt-4">
      <div class="card">
        <div class="card-body p-3 position-relative">
          <div class="row">
            <div class="col-7 text-start">
              <p class="text-sm mb-1 text-capitalize font-weight-bold">Upcoming Projects</p>
              <h5 class="font-weight-bolder mb-0">
              <?php echo($upcomingprojects); ?>
              </h5>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-4 mt-4">
      <div class="card">
        <div class="card-body p-3 position-relative">
          <div class="row">
            <div class="col-7 text-start">
              <p class="text-sm mb-1 text-capitalize font-weight-bold">Completed Projects</p>
              <h5 class="font-weight-bolder mb-0">
                <?php echo($completedprojects); ?>
              </h5>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-4 mt-4">
      <div class="card">
        <div class="card-body p-3 position-relative">
          <div class="row">
            <div class="col-7 text-start">
              <p class="text-sm mb-1 text-capitalize font-weight-bold">Today's Appointment</p>
              <h5 class="font-weight-bolder mb-0">
              <?php echo($todayappointment); ?>
              </h5>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row mt-4">
    <div class="col-12">
      <div class="card mb-4">
        <div class="card-header pb-0">
          <h6>Top Projects</h6>
        </div>
        <div class="card-body px-0 pt-0 pb-2">
          <div class="table-responsive p-0">
            <table class="table align-items-center mb-0">
              <thead>
                <tr>
                  <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Project</th>
                  <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Status</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach($projects as $project){ ?>
                
                <tr>
                  <td>
                    <div class="d-flex px-3 py-1">
                      <div>
                        <img src="<?=base_url('assets/front/images/'. $project['featured_image']) ?>" class="avatar me-3" alt="image">
                      </div>
                      <div class="d-flex flex-column justify-content-center">
                        <h6 class="mb-0 text-sm"><?=$project['name']; ?></h6>
                        <!-- <p class="text-sm font-weight-normal text-secondary mb-0"><span class="text-success">8.232</span> orders</p> -->
                      </div>
                    </div>
                  </td>
                  <td class="align-middle text-end">
                    <div class="d-flex px-3 py-1 justify-content-center align-items-center">
                      <p class="text-sm font-weight-normal mb-0"><?=$project['category']; ?></p>
                    </div>
                  </td>
                </tr>
              <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</main>
<?php $this->load->view('admin/footer'); ?>

<script>
  var ctx1 = document.getElementById("chart-line").getContext("2d");
  var ctx2 = document.getElementById("chart-pie").getContext("2d");
  var ctx3 = document.getElementById("chart-bar").getContext("2d");

  // Line chart
  new Chart(ctx1, {
    type: "line",
    data: {
      labels: ["Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
      datasets: [{
          label: "Facebook Ads",
          tension: 0,
          pointRadius: 5,
          pointBackgroundColor: "#e91e63",
          pointBorderColor: "transparent",
          borderColor: "#e91e63",
          borderWidth: 4,
          backgroundColor: "transparent",
          fill: true,
          data: [50, 100, 200, 190, 400, 350, 500, 450, 700],
          maxBarThickness: 6
        },
        {
          label: "Google Ads",
          tension: 0,
          borderWidth: 0,
          pointRadius: 5,
          pointBackgroundColor: "#3A416F",
          pointBorderColor: "transparent",
          borderColor: "#3A416F",
          borderWidth: 4,
          backgroundColor: "transparent",
          fill: true,
          data: [10, 30, 40, 120, 150, 220, 280, 250, 280],
          maxBarThickness: 6
        }
      ],
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        }
      },
      interaction: {
        intersect: false,
        mode: 'index',
      },
      scales: {
        y: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: '#c1c4ce5c'
          },
          ticks: {
            display: true,
            padding: 10,
            color: '#9ca2b7',
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
        x: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: true,
            borderDash: [5, 5],
            color: '#c1c4ce5c'
          },
          ticks: {
            display: true,
            color: '#9ca2b7',
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
      },
    },
  });


  // Pie chart
  new Chart(ctx2, {
    type: "pie",
    data: {
      labels: ['Facebook', 'Direct', 'Organic', 'Referral'],
      datasets: [{
        label: "Projects",
        weight: 9,
        cutout: 0,
        tension: 0.9,
        pointRadius: 2,
        borderWidth: 1,
        backgroundColor: ['#17c1e8', '#e91e63', '#3A416F', '#a8b8d8'],
        data: [15, 20, 12, 60],
        fill: false
      }],
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        }
      },
      interaction: {
        intersect: false,
        mode: 'index',
      },
      scales: {
        y: {
          grid: {
            drawBorder: false,
            display: false,
            drawOnChartArea: false,
            drawTicks: false,
            color: '#c1c4ce5c'
          },
          ticks: {
            display: false
          }
        },
        x: {
          grid: {
            drawBorder: false,
            display: false,
            drawOnChartArea: false,
            drawTicks: false,
            color: '#c1c4ce5c'
          },
          ticks: {
            display: false,
          }
        },
      },
    },
  });

  // Bar chart
  new Chart(ctx3, {
    type: "bar",
    data: {
      labels: ['16-20', '21-25', '26-30', '31-36', '36-42', '42-50', '50+'],
      datasets: [{
        label: "Sales by age",
        weight: 5,
        borderWidth: 0,
        borderRadius: 4,
        backgroundColor: '#3A416F',
        data: [15, 20, 12, 60, 20, 15, 25],
        fill: false
      }],
    },
    options: {
      indexAxis: 'y',
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        }
      },
      scales: {
        y: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: '#c1c4ce5c'
          },
          ticks: {
            display: true,
            padding: 10,
            color: '#c1c4ce5c',
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
        x: {
          grid: {
            drawBorder: false,
            display: false,
            drawOnChartArea: true,
            drawTicks: true,
            color: '#9ca2b7'
          },
          ticks: {
            display: true,
            color: '#9ca2b7',
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
      },
    },
  });
</script>
<script>
  var win = navigator.platform.indexOf('Win') > -1;
  if (win && document.querySelector('#sidenav-scrollbar')) {
    var options = {
      damping: '0.5'
    }
    Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
  }
</script>
<script>
  var ctx = document.getElementById("chart-bars").getContext("2d");

  new Chart(ctx, {
    type: "bar",
    data: {
      labels: ["M", "T", "W", "T", "F", "S", "S"],
      datasets: [{
        label: "Sales",
        tension: 0.4,
        borderWidth: 0,
        borderRadius: 4,
        borderSkipped: false,
        backgroundColor: "rgba(255, 255, 255, .8)",
        data: [50, 20, 10, 22, 50, 10, 40],
        maxBarThickness: 6
      }, ],
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        }
      },
      interaction: {
        intersect: false,
        mode: 'index',
      },
      scales: {
        y: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: 'rgba(255, 255, 255, .2)'
          },
          ticks: {
            suggestedMin: 0,
            suggestedMax: 500,
            beginAtZero: true,
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
            color: "#fff"
          },
        },
        x: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: 'rgba(255, 255, 255, .2)'
          },
          ticks: {
            display: true,
            color: '#f8f9fa',
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
      },
    },
  });


  var ctx2 = document.getElementById("chart-line").getContext("2d");

  new Chart(ctx2, {
    type: "line",
    data: {
      labels: ["Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
      datasets: [{
        label: "Mobile apps",
        tension: 0,
        borderWidth: 0,
        pointRadius: 5,
        pointBackgroundColor: "rgba(255, 255, 255, .8)",
        pointBorderColor: "transparent",
        borderColor: "rgba(255, 255, 255, .8)",
        borderColor: "rgba(255, 255, 255, .8)",
        borderWidth: 4,
        backgroundColor: "transparent",
        fill: true,
        data: [50, 40, 300, 320, 500, 350, 200, 230, 500],
        maxBarThickness: 6

      }],
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        }
      },
      interaction: {
        intersect: false,
        mode: 'index',
      },
      scales: {
        y: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: 'rgba(255, 255, 255, .2)'
          },
          ticks: {
            display: true,
            color: '#f8f9fa',
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
        x: {
          grid: {
            drawBorder: false,
            display: false,
            drawOnChartArea: false,
            drawTicks: false,
            borderDash: [5, 5]
          },
          ticks: {
            display: true,
            color: '#f8f9fa',
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
      },
    },
  });

  var ctx3 = document.getElementById("chart-line-tasks").getContext("2d");

  new Chart(ctx3, {
    type: "line",
    data: {
      labels: ["Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
      datasets: [{
        label: "Mobile apps",
        tension: 0,
        borderWidth: 0,
        pointRadius: 5,
        pointBackgroundColor: "rgba(255, 255, 255, .8)",
        pointBorderColor: "transparent",
        borderColor: "rgba(255, 255, 255, .8)",
        borderWidth: 4,
        backgroundColor: "transparent",
        fill: true,
        data: [50, 40, 300, 220, 500, 250, 400, 230, 500],
        maxBarThickness: 6

      }],
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        }
      },
      interaction: {
        intersect: false,
        mode: 'index',
      },
      scales: {
        y: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: 'rgba(255, 255, 255, .2)'
          },
          ticks: {
            display: true,
            padding: 10,
            color: '#f8f9fa',
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
        x: {
          grid: {
            drawBorder: false,
            display: false,
            drawOnChartArea: false,
            drawTicks: false,
            borderDash: [5, 5]
          },
          ticks: {
            display: true,
            color: '#f8f9fa',
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
      },
    },
  });
</script>