<?php $this->load->view('admin/head'); ?>
<?php $this->load->view('admin/header'); ?>
<div class="container-fluid py-4 mt-5">
    <div class="card">
        <div class="card-header p-0 position-relative mt-n5 mx-3 z-index-2">
            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                <center>
                    <h5 class="font-weight-bolder text-white">Project Information</h5>
                </center>
            </div>
        </div>
        <div class="card-body">
            <form class="multisteps-form__form" method="post" action="addprojects" enctype="multipart/form-data">

                <div class="pt-3 border-radius-xl bg-white" data-animation="FadeIn">

                    <div class="multisteps-form__content">
                        <div class="row mt-3">
                            <div class="col-12 col-sm-6">
                                <input type="hidden" name="date_added" value="<?=date("Y-m-d"); ?>">
                                <input type="hidden" name="images" value="[]">
                                <div class="input-group input-group-static m-2">
                                    <label for="name">Project Title *</label>
                                    <input class="form-control" type="text" name="name" id="name" required>
                                </div>
                                <div class="input-group input-group-static m-2">
                                    <label for="area">Area</label>
                                    <input class="form-control" type="text" name="area" id="area" >
                                </div>
                                <div class="input-group input-group-static m-2">
                                    <label for="video">Video (Ex. https://www.youtube.com/watch?v=<b>r0hs0DMUlEU</b>)</label>
                                    <input class="form-control" type="text" name="video" id="video" >
                                </div>
                                <div class="input-group input-group-static m-2">
                                    <label for="price">Price</label>
                                    <input class="form-control" type="text" name="price" id="price" >
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 mt-3 mt-sm-0">
                                <div class="input-group input-group-static m-2">
                                    <label for="category">Status</label>
                                    <select class="form-control" name="category" required>
                                        <option value="">Select Status</option>
                                        <option value="upcoming">Upcoming</option>
                                        <option value="ongoing">Ongoing</option>
                                        <option value="completed">Completed</option>
                                    </select>
                                </div>
                                <div class="input-group input-group-static m-2">
                                    <label for="address">Address</label>
                                    <input class="form-control" type="text" name="address" id="address" >
                                </div>
                                <div class="input-group input-group-static m-2">
                                    <label for="Location">Location (Ex. 26.822966,75.452848)</label>
                                    <input class="form-control" type="text" name="location" id="location" >
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="input-group input-group-static">
                            <label for="choices-tags">Features</label>
                            <input class="form-control" name="features[]" id="choices-tags" data-color="dark" type="text" />
                            </div>
                            <div class="col-12 col-sm-12">
                                <label for="description">Description</label>
                                <div class="input-group input-group-static m-2">
                                    <textarea class="form-control" name="description"></textarea>
                                </div>
                            </div>
                            <div class="input-group input-group-static m-2">
                                <label for="image">Thumbnail Image</label>
                                <div class="input-group input-group-static m-2">
                                    <input type="file" name="image" accept="image/*" required />
                                    <p>(Image Size Should be 958*1280)</p>
                                </div>
                                <?php
                                if (!empty($_SESSION['success_msg'])) {
                                    echo '<p class="status-msg success">' . $success_msg . '</p>';
                                } elseif (!empty($_SESSION['error_msg'])) {
                                    echo '<p class="status-msg error">' . $_SESSION['error_msg'] . '</p>';
                                }
                                ?>
                            </div>
                            
                            <div class="input-group input-group-static m-2">
                                <label for="pdf">Brochure PDF</label>
                                <div class="input-group input-group-static m-2">
                                    <input type="file" name="pdf" accept=".pdf" />
                                    <p>(PDF Size Should be Less than 10MB)</p>
                                </div>
                                <?php
                                if (!empty($_SESSION['success_msg'])) {
                                    echo '<p class="status-msg success">' . $success_msg . '</p>';
                                } elseif (!empty($_SESSION['error_msg'])) {
                                    echo '<p class="status-msg error">' . $_SESSION['error_msg'] . '</p>';
                                }
                                ?>
                            </div>
                        </div>
                        <button type="submit" name="submit" class="btn btn-primary w-20 mt-5">Submit</button>
                    </div>
                </div>
        </div>
    </div>
    </form>
</div>
</div>
</div>
</main>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    CKEDITOR.replace('description');
</script>
<?php $this->load->view('admin/footer'); ?>