<?php
#[\AllowDynamicProperties]
class Project_model extends CI_Model
{

    public function getdata($field = NULL, $value = NULL)
    {
        $this->load->database();
        if ($field != NULL && $value != NULL) {
            $this->db->where('status', 1);
            // $where = "name='Joe' AND status='boss' OR status='active'";
            $this->db->where($field, $value);
        }
        $query = $this->db->get('project');
        return $query->result_array();
    }

    public function get_project($link)
    {

        $query = $this->db->get_where('project', array('link' => $link));
        return $query->row();
    }

    public function checkproject($link)
    {

        $query = $this->db->get_where('project', array('link' => $link));
        if ($query->num_rows() > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    public function subcategory($link)
    {

        $query = $this->db->get_where('category', array('parent' => $link));
        return $query->result_array();
    }

    public function get_category($link)
    {

        $query = $this->db->get_where('category', array('link' => $link));
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return 0;
        }
    }
    public function getmaincategories()
    {
        $this->db->where('parent', NULL);
        $query = $this->db->get('category');
        return $query->result_array();
    }
    public function getchildcategories()
    {
        $this->db->where('parent != ');
        $query = $this->db->get('category');
        return $query->result_array();
    }
    public function getcategories()
    {
        $query = $this->db->get('category');
        return $query->result_array();
    }
    public function checkcategory($link)
    {

        $query = $this->db->get_where('category', array('link' => $link));
        if ($query->num_rows() > 0) {
            return 1;
        } else {
            return 0;
        }
    }
    public function categoryprojects($link, $data = NULL)
    {
        // $query = $this->db->get_where('project', array('category' => $link));
        $query = "SELECT * FROM project WHERE status = '1'";
        if($link == "new"){
            $query .= "AND new_arrival = 'on'";
        }else{
            $query .= "AND category = '$link'";
        }
        if ($data != NULL) {
              if(isset($data['minimum_price'], $data['maximum_price']) && !empty($data['minimum_price']) &&  !empty($data['maximum_price']))
              {
               $query .= "
                AND saleprice BETWEEN '".$data['minimum_price']."' AND '".$data['maximum_price']."'
               ";
              }
            
              if(isset($data['color']))
              {
            //   $color_filter = implode("','", $data['color']);
               $query .= "
                AND color = '".$data['color']."'
               ";
              }
              
              if(isset($data['order']))
              {
            //   $color_filter = implode("','", $color);
               $query .= "
                ORDER BY price ".$data['order']."
               ";
              }
        }
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function activate($table = NULL, $link = NULL)
    {
        if ($table == "users" || $table == "reviews" || $table == "coupons") {
            $this->db->set('status', 1);
            $this->db->where('id', $link);
            $this->db->update($table);
        } else {
            $this->db->set('status', 1);
            $this->db->where('link', $link);
            $this->db->update($table);
        }
    }
    public function deactivate($table = NULL, $link = NULL)
    {
        if ($table == "users") {
            $this->db->set('status', 2);
            $this->db->where('id', $link);
            $this->db->update($table);
        } else if ($table == "coupons" || $table == "reviews") {
            $this->db->set('status', 0);
            $this->db->where('id', $link);
            $this->db->update($table);
        } else {
            $this->db->set('status', 0);
            $this->db->where('link', $link);
            $this->db->update($table);
        }
    }

    public function delete($table = NULL, $link = NULL)
    {
        if ($table == "director" || $table == "reviews") {
            $this->db->where('id', $link);
            $this->db->delete($table);
            return true;
        }else {
            $this->db->where('link', $link);
            $this->db->delete($table);
            return true;
        }
    }

    public function removeimg($table = NULL, $link = NULL)
    {
        if($table == 'director'){
            $this->db->set('image',"");
            $this->db->where('id', $link);
            $this->db->update('director');
        }else if($table == 'blog'){
            $this->db->set('image',"");
            $this->db->where('link', $link);
            $this->db->update('blog');
        }else if($table == 'reviews'){
            $this->db->set('image',"");
            $this->db->where('id', $link);
            $this->db->update('reviews');
        }
        else{
            $this->db->set('featured_image',"");
            $this->db->where('link', $link);
            $this->db->update($table);
        }
        
        
    }

    public function removecat($table = NULL, $link = NULL)
    {
        if($table == 'blog'){
            $this->db->set('blogger_image',"");
            $this->db->where('link', $link);
            $this->db->update('blog');
        }
        else{
        $this->db->set('image',"");
        $this->db->where('link', $link);
        $this->db->update($table);
        }
    }

    public function saveimage($link, $images)
    {
        $this->db->set('images', $images);
        $this->db->where('link', $link);
        $this->db->update('project');
    }

    public function removepdf($table = NULL, $link = NULL)
    {
        $this->db->set('pdf',"");
        $this->db->where('link', $link);
        $this->db->update($table);
    }

    public function getimages($link)
    {
        $this->db->select('images');
        $this->db->from('project');
        if ($link) {
            $this->db->where('link', $link);
            $query = $this->db->get();
            $result = $query->row();
        } else {
            $query = $this->db->get();
            $result = $query->result_array();
        }

        return !empty($result) ? $result : false;
    }
    


    /* 
     * Insert file data into the database 
     * @param array the data for inserting into the table 
     */
    public function insert($data = array())
    {
        $insert = $this->db->insert('project', $data);
        return $insert ? true : false;
    }
    
}
