<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Home extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('Blog_model');
		$this->load->model('Project_model');
		$this->Global = $this->Global_model->getdata();
		$this->Global['posts'] = $this->Blog_model->get_posts();
		$this->Global['getprojects'] = $this->Project_model->getdata();
		$this->Global['gallery'] = $this->Global_model->getactivegallery();
		$this->Global['sliders'] = $this->Global_model->getactiveslider();
		$this->Global['reviews'] = $this->Global_model->getactivereviews();
		$this->Global['about'] = $this->Global_model->getpage("about")[0];
	}

	public function index()
	{
		$this->Global['directors'] = $this->Global_model->getdirectors('status','1');
		$this->load->view('front/index', $this->Global);
	}
	public function about()
	{
		$this->Global['directors'] = $this->Global_model->getdirectors('status','1');
		$this->Global['about'] = $this->Global_model->getpage("about")[0];
		$this->load->view('front/about', $this->Global);
	}
	public function vision()
	{
		$this->Global['vision'] = $this->Global_model->getpage("vision")[0];
		$this->load->view('front/our-vision', $this->Global);
	}
	public function career()
	{
		$this->Global['career'] = $this->Global_model->getpage("career")[0];
		$this->load->view('front/career', $this->Global);
	}
    // 	public function upcoming()
    // 	{
    // 		$this->Global['projects'] = $this->Global_model->getprojects("category","upcoming");
    // 		$this->Global['title'] = "Upcoming Project";
    // 		$this->load->view('front/category', $this->Global);
    // 	}
    // 	public function ongoing()
    // 	{
    // 		$this->Global['projects'] = $this->Global_model->getprojects("category","ongoing");
    // 		$this->Global['title'] = "Ongoing Project";
    // 		$this->load->view('front/category', $this->Global);
    // 	}
    // 	public function completed()
    // 	{
    // 		$this->Global['projects'] = $this->Global_model->getprojects("category","completed");
    // 		$this->Global['title'] = "Completed Project";
    // 		$this->load->view('front/category', $this->Global);
    // 	}
    
    	public function projects()
    	{
    		$this->Global['projects'] = $this->Global_model->getprojects("status","1");
    		$this->Global['title'] = "Our Project";
    		$this->load->view('front/category', $this->Global);
    	}
    
    
	public function gallery()
	{
		$this->Global['projects'] = $this->Global_model->getgallery();
		$this->load->view('front/gallery', $this->Global);
	}
	public function contact()
	{
		$this->load->view('front/contact', $this->Global);
	}

	public function project($req = null)
	{

		if ($this->Project_model->checkproject($req)) {
			$this->Global['project'] = $this->Project_model->get_project($req);
			$this->load->view('front/project-detail', $this->Global);
		} else {
			redirect('error');
		}
	}

	public function save(){
		$data = $_POST;
		$this->Global['project'] = $this->Global_model->save($data);
		$data['toemail'] = array(admin_email);
		$mail_message = sitename." Enquiry";
		$mail_message .="<br/>Name - ".$_REQUEST['name'];
		$mail_message .="<br/>Email - ".$_REQUEST['email'];
		$mail_message .="<br/>Mobile - ".$_REQUEST['phoneno'];
		$mail_message .="<br/>Message - ".$_REQUEST['message'];
		$data['message'] = $mail_message;
		$this->Global_model->send_mail($data);
		redirect('home/thanks');
	}
	
	public function enquiry(){
		$data = $_POST;
		unset($data['pdf']);
		$this->Global['project'] = $this->Global_model->save($data);
		$data['toemail'] = array(admin_email);
		$mail_message = sitename." Enquiry";
		$mail_message .="<br/>Name - ".$_REQUEST['name'];
		$mail_message .="<br/>Email - ".$_REQUEST['email'];
		$mail_message .="<br/>Mobile - ".$_REQUEST['phoneno'];
		$mail_message .="<br/>Message - ".$_REQUEST['message'];
		$data['message'] = $mail_message;
		$this->Global_model->send_mail($data);
		if($_REQUEST['pdf'] != ''){
		    redirect($_REQUEST['pdf']);
		}
		else{
		    redirect('home/thanks');
		}
	}

	public function thanks(){
		$this->load->view('front/thanks', $this->Global);
	}
	
	public function blogs($start = 0)//index page
    {
        $this->Global['posts'] = $this->Blog_model->get_posts(5, $start);

        //pagination
        $this->load->library('pagination');
        $config['total_rows'] = $this->Blog_model->get_post_count();
        $config['per_page'] = 5;
        $this->pagination->initialize($config);
        
        $this->load->view('front/blog', $this->Global);
    }

    function blog($slug)//single post page
    {
        $this->Global['blog'] = $this->Blog_model->get_post($slug);
        $this->load->view('front/blog-detail', $this->Global);
    }
	
}
